<?php

namespace Mainto\RpcServer\Tracing;

class Context
{
    const TRACE_PARENT_HEADER = 'traceParent';
    const SUPPORTED_VERSION = 0;
    const MAX_VERSION = 254;

    /**
     * @return string
     */
    public static function getHeaderValue(): string
    {
        // tracer
        $tracer = Tracer::getInstance();
        // 返回
        return sprintf(
            "%02d-%s-%s-%02d",
            number_format(static::SUPPORTED_VERSION, 2),
            $tracer->getTraceId(),
            $tracer->getCurrentSpanId(),
            $tracer->sampled() & 0x01
        );
    }

    /**
     * @param string $traceId
     * @param string $headerValue
     *
     * @return Tracer
     */
    public static function extract(string $traceId, string $headerValue): Tracer
    {
        // tracer
        $tracer = Tracer::getInstance();
        // 判断是否为空
        if (!empty($headerValue)) {
            list($version, $traceId, $spanId, $sampled) = explode('-', $headerValue, 4);
            $tracer->setTraceId($traceId, $spanId);
        } else {
            $tracer->setTraceId($traceId);
        }

        return $tracer;
    }
}