<?php

namespace Mainto\RpcServer\RpcServer\Middleware\Kernel;

use Closure;
use Mainto\RpcServer\Tracing\Context;
use Mainto\RpcServer\Tracing\Span;
use Throwable;
use Mainto\RpcServer\Protocol\Response\Response;
use Mainto\RpcServer\RpcServer\Middleware\KernelMiddleware;
use Mainto\RpcServer\RpcServer\RpcStreamContext;
use Mainto\RpcServer\Tracing\Tracer;

class TracingKernelMiddleware implements KernelMiddleware {

    /**
     * @param RpcStreamContext $context
     * @param Closure $next
     * @return Response
     * @throws Throwable
     */
    public function handle (RpcStreamContext $context, Closure $next): Response {
        // 判断traceId是否为空
        if ($context->request->getType() != 17) {
            return $next($context);
        }
        // 获取所有header
        $headers = $context->request->getAllHeaders();
        // 处理上下文
        $tracer = Context::extract($context->request->getTraceId(), $headers[Context::TRACE_PARENT_HEADER] ?? '');
        // 防止报错
        try {
            $span = Span::start('requestMiddleware');
            $response = $next($context);
            $span->end();
        } catch (Throwable $e) {
            $tracer->error($e);
            throw $e;
        } finally {
            Tracer::getInstance()->flush();
        }
        return $response;
    }
}