<?php

namespace Mainto\RpcServer\Listeners;

use Illuminate\Redis\Events\CommandExecuted;
use Mainto\RpcServer\Tracing\Span;

class RedisCommandExecuted {
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct () {
        //
    }

    /**
     * Handle the event.
     *
     * @param CommandExecuted $event
     * @return void
     */
    public function handle (CommandExecuted $event) {
        //
        $span = Span::start("redis_command_executed");
        $span->setAttribute("connection_name", $event->connectionName);
        $span->setAttribute("command", $event->command);
        $span->setAttribute("time", $event->time);
        $span->setAttribute("parameters", join(",", $event->parameters));
        $span->end();

    }
}
