<?php

namespace Mainto\RpcServer\Listeners;

use Illuminate\Database\Events\QueryExecuted;
use Mainto\RpcServer\Tracing\Span;

class DatabaseQueryExecuted {
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct () {
        //
    }

    /**
     * Handle the event.
     *
     * @param QueryExecuted $event
     * @return void
     */
    public function handle (QueryExecuted $event) {
        //
        $span = Span::start("mysql_query_executed");
        $span->setAttribute("connection_name", $event->connectionName);
        $span->setAttribute("sql", $event->sql);
        $span->setAttribute("time", $event->time);
        $span->setAttribute("bindings", join(",", $event->bindings));
        $span->end();

    }
}
