<?php

namespace Mainto\RpcServer\Tracing\Support\Aliyun;

use Mainto\RpcServer\RpcUtil\Tool\RpcLog;
use Mainto\RpcServer\Tracing\Source;

class Exporter
{
    /**
     * @var Converter
     */
    private Converter $converter;

    /**
     * 实例化
     */
    public function __construct()
    {
        $this->converter = new Converter();
    }

    /**
     * @param array $spans
     * @param Source $source
     */
    public function export(array $spans, Source $source): void
    {
        // 默认值
        $convertSpans = $this->converter->converts($spans, $source);
        // 提交
        RpcLog::getInstance()->tracer($convertSpans);
    }
}
