<?php

namespace Mainto\RpcServer\Tracing\Support\Zipkin;

use GuzzleHttp\Client;
use Mainto\RpcServer\Tracing\Source;
use Throwable;

class Exporter
{
    /**
     * @var Converter
     */
    private Converter $converter;

    /**
     * 实例化
     */
    public function __construct()
    {
        $this->converter = new Converter();
    }

    /**
     * @param array $spans
     * @param Source $source
     */
    public function export(array $spans, Source $source): void
    {
        $uri = 'http://127.0.0.1:9412/api/v2/spans';
        // 默认值
        $logs = $this->converter->converts($spans, $source);
        // 提交
        $response = (new Client())->post($uri, [
            'json' => $logs,
        ]);
    }
}
