<?php

namespace Mainto\RpcServer\Tracing\Support\Aliyun;

use Mainto\RpcServer\Tracing\Source;
use Mainto\RpcServer\Tracing\Span;

class Converter
{
    /**
     * @param array $spans
     * @param Source $source
     * @return array
     */
    public function converts(array $spans, Source $source): array
    {
        // 默认值
        $convertedSpans = [];
        // 遍历循环spans
        foreach ($spans as $span) {
            // 转换
            array_push($convertedSpans, $this->convert($span, $source));
        }
        //
        return $convertedSpans;
    }

    /**
     * @param Span $span
     * @param Source $source
     * @return array
     */
    private function convert(Span $span, Source $source): array
    {
        // 判断是否已结束
        if ($span->isRecording()) {
            $span->end();
        }
        //
        return [];
    }
}
