<?php

namespace Mainto\RpcServer\Tracing\Span;

trait Timer
{
    /**
     * @var string
     */
    protected string $start;

    /**
     * @var string
     */
    protected string $end;

    /**
     * @var int
     */
    protected int $duration;

    /**
     * @return string
     */
    public function getStart(): string
    {
        return $this->start;
    }

    /**
     * @return string
     */
    public function getEnd(): string
    {
        return $this->end;
    }

    /**
     * @return int
     */
    public function getDuration(): int
    {
        return $this->duration;
    }

    /**
     * @param string|float $time
     */
    public function end(string $time = ''): void
    {
        // 判断是否为空
        if (empty($time) && !empty($this->end)) {
            return;
        }
        $this->end = $time ?: microtime(true);
        $this->duration = $this->start - $this->end;
    }

    /**
     * @return bool
     */
    public function isRecording(): bool
    {
        return null === $this->end;
    }
}
