<?php

namespace Mainto\RpcServer\Tracing\Span;

use Mainto\RpcServer\Tracing\Interfaces\SpanStatus;

trait Status
{
    /**
     * @var string
     */
    protected string $statusCode;

    /**
     * @var string
     */
    protected string $statusMessage;

    /**
     * @return string
     */
    public function getStatusCode(): string
    {
        return $this->statusCode;
    }

    /**
     * @return string
     */
    public function getStatusMessage(): string
    {
        return $this->statusMessage;
    }

    /**
     * @return $this
     */
    public function statusOk(): self
    {
        $this->statusCode = SpanStatus::OK;
        return $this->setStatusMessage();
    }

    /**
     * @return $this
     */
    public function statusError(): self
    {
        $this->statusCode = SpanStatus::ERROR;
        return $this->setStatusMessage();
    }

    /**
     * @return $this
     */
    public function statusUnset(): self
    {
        $this->statusCode = SpanStatus::ERROR;
        return $this->setStatusMessage();
    }

    /**
     * @return $this
     */
    private function setStatusMessage(): self
    {
        $this->statusMessage = SpanStatus::DESCRIPTION[$this->statusCode] ?? '';
        return $this;
    }
}
