<?php

namespace Mainto\RpcServer\Tracing;

use Mainto\RpcServer\Tracing\Span\Attribute;
use Mainto\RpcServer\Tracing\Span\Link;
use Mainto\RpcServer\Tracing\Span\Log;
use Mainto\RpcServer\Tracing\Span\Resource;
use Mainto\RpcServer\Tracing\Span\Status;
use Mainto\RpcServer\Tracing\Span\Timer;

class Span
{
    use Attribute, Link, Log, Resource, Timer, Status;

    /**
     * @var string
     */
    protected string $name;

    /**
     * @var string
     */
    protected string $kind;

    /**
     * @var string
     */
    protected string $spanId;

    /**
     * @var string
     */
    protected string $traceId;

    /**
     * @var string
     */
    protected string $parentSpanId;

    /**
     * @param string $name
     */
    public function __construct(string $name = '')
    {
        $tracer = Tracer::getInstance();

        $this->traceId = $tracer->getTraceId();
        $this->spanId = $tracer->getIdGenerator()->generateSpanId();
        $this->start = microtime(true);
        $this->name = $name;
        $this->parentSpanId = $tracer->getParentSpanId() ?: $this->spanId;
        $this->statusUnset();

        // 存入span
        $tracer->appendSpan($this);
    }

    /**
     * @param string $name
     * @return Span
     */
    public static function start(string $name): Span
    {
        return new Span($name);
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getKind(): string
    {
        return $this->kind;
    }

    /**
     * @return string
     */
    public function getSpanId(): string
    {
        return $this->spanId;
    }

    /**
     * @return string
     */
    public function getTraceId(): string
    {
        return $this->traceId;
    }

    /**
     * @return string
     */
    public function getParentId(): string
    {
        return $this->parentSpanId;
    }
}
