<?php

namespace Mainto\RpcServer\Tracing;

use Mainto\RpcServer\Tracing\Span\Attribute;
use Mainto\RpcServer\Tracing\Span\Resource;

class Source
{
    use Attribute, Resource;

    /**
     * @var string
     */
    protected string $host;

    /**
     * @var string
     */
    protected string $serviceName;

    /**
     * @var SdkVersion
     */
    protected SdkVersion $sdkVersion;

    /**
     * 构造函数
     */
    public function __construct(SdkVersion $sdkVersion)
    {
        $this->host = gethostname() ?? 'unknown';
        $this->serviceName = env('RPC_SERVER_NAME', 'NoName');
        $this->sdkVersion = $sdkVersion;
    }

    /**
     * @return string
     */
    public function getHost(): string
    {
        return $this->host;
    }

    /**
     * @return string
     */
    public function getServiceName(): string
    {
        return $this->serviceName;
    }

    /**
     * @return SdkVersion
     */
    public function getSdkVersion(): SdkVersion
    {
        return $this->sdkVersion;
    }
}
