<?php

namespace Mainto\RpcServer\Tracing\Traits;

trait Attributes {
    /**
     * @var array
     */
    protected array $attributes = [];

    /**
     * @param string $key
     * @param string $value
     *
     * @return $this
     */
    public function setAttribute (string $key, string $value): self {
        $this->attributes[$key] = $value;
        return $this;
    }

    /**
     * @return array
     */
    public function getAttributes (): array {
        return $this->attributes;
    }
}
