<?php

namespace Mainto\RpcServer\Tracing\Listeners;

use Illuminate\Cache\Events\KeyWritten;
use Mainto\RpcServer\Tracing\Context;
use Mainto\RpcServer\Tracing\Span;

class KeyWrittenListener {
    /**
     * Handle the event.
     *
     * @param KeyWritten $event
     * @return void
     */
    public function handle (KeyWritten $event) {
        $span = Context::currentSpan();
        if (empty($span)) {
            $span = Span::start('KeyWritten');
        }
        $span->addEvent('KeyWritten', 0, [
            'key' => $event->key,
            'value' => $event->value,
            'seconds' => $event->seconds,
        ]);
    }
}