<?php

namespace Mainto\RpcServer\Tracing\Listeners;

use Illuminate\Database\Events\QueryExecuted;
use Mainto\RpcServer\Tracing\Context;
use Mainto\RpcServer\Tracing\Span;

class DatabaseQueryListener {
    /**
     * Handle the event.
     *
     * @param QueryExecuted $event
     * @return void
     */
    public function handle (QueryExecuted $event) {
        $span = Context::currentSpan();
        if (empty($span)) {
            $span = Span::start('mysql_query_executed');
        }

        $span->addEvent('mysql_query_executed', time(), [
            'connection_name' => $event->connectionName,
            'sql' => $event->sql,
            'time' => $event->time,
            'bindings' => join(',', $event->bindings)
        ]);
    }
}
