<?php

namespace Mainto\RpcServer\Tracing\Listeners;

use Illuminate\Cache\Events\CacheMissed;
use Mainto\RpcServer\Tracing\Context;
use Mainto\RpcServer\Tracing\Span;

class CacheMissedListener {
    /**
     * Handle the event.
     *
     * @param CacheMissed $event
     * @return void
     */
    public function handle (CacheMissed $event) {
        $span = Context::currentSpan();
        if (empty($span)) {
            $span = Span::start('CacheMissed');
        }
        $span->addEvent('CacheMissed', 0, [
            'key' => $event->key,
        ]);
    }
}