<?php

namespace Mainto\RpcServer\Tracing\Listeners;

use Illuminate\Cache\Events\CacheHit;
use Mainto\RpcServer\Tracing\Context;
use Mainto\RpcServer\Tracing\Span;

class CacheHitListener {
    /**
     * Handle the event.
     *
     * @param CacheHit $event
     * @return void
     */
    public function handle (CacheHit $event) {
        $span = Context::currentSpan();
        if (empty($span)) {
            $span = Span::start('CacheHit');
        }
        $span->addEvent('CacheHit', 0, [
            'key' => $event->key,
        ]);
    }
}