<?php

namespace Mainto\RpcServer\Tracing;

use Mainto\RpcServer\Tracing\Interfaces\Time;
use Mainto\RpcServer\Tracing\Traits\Attributes;

class Event {
    use Attributes;

    /**
     * @var string
     */
    private string $name;

    /**
     * @var float
     */
    private float $timestamp;

    /**
     * @param string $name
     * @param float $timestamp
     * @param array $attributes
     */
    public function __construct (string $name, float $timestamp = 0, array $attributes = []) {
        $this->name = $name;
        $this->timestamp = $timestamp ?: \time();
        $this->attributes = $attributes;
    }

    /**
     * @return string
     */
    public function getName (): string {
        return $this->name;
    }

    /**
     * @return int
     */
    public function getTimestamp (): int {
        return $this->timestamp;
    }
}
