<?php

namespace Mainto\RpcServer\Tracing;

use Mainto\RpcServer\Tracing\Interfaces\Exporter;

class Processor {
    /**
     * @var Span[]
     */
    protected array $spans = [];

    /**
     * @var Exporter
     */
    protected Exporter $exporter;

    /**
     * @var Source
     */
    protected Source $source;

    /**
     * @param Exporter $exporter
     * @param Source $source
     */
    public function __construct (Exporter $exporter, Source $source) {
        $this->exporter = $exporter;
        $this->source = $source;
    }

    /**
     * @param Span $span
     */
    public function onStart (Span $span): void {
        array_push($this->spans, $span);
        Context::setSpanContext($span->getContext());
    }

    /**
     * @param Span $span
     */
    public function onEnd (Span $span): void {
        if (!empty($span->parent())) {
            Context::setSpanContext($span->parent()->getContext());
        }
    }

    /**
     * 退出
     */
    public function shutdown (): void {
        if (!empty($this->spans)) {
            $this->forceFlush();
        }
    }

    /**
     * 强制提交
     */
    public function forceFlush (): void {
        if (empty($this->spans)) {
            return;
        }
        // 遍历循环, 进行最终检查
        foreach ($this->spans as $span) {
            // 判断是否结束
            if ($span->isRecording()) {
                $span->end();
            }
        }
        $this->exporter->export($this->spans, $this->source);
        $this->spans = [];
    }
}