<?php


namespace Mainto\RpcServer\Providers\SqlTrace;

use Closure;
use Mainto\RpcServer\RpcServer\RpcInvoke;
use Mainto\RpcServer\Tracing\Span;

class MysqlConnection extends \Illuminate\Database\MySqlConnection {
    public function run ($query, $bindings, Closure $callback) {
        $span = Span::start('mysql_executed');
        try {
            $span->setAttribute('sql', $query);
            $span->setAttribute('bindings', join(',', $bindings));
            $query = "/* TraceId: ".RpcInvoke::getCurrentTraceId()." */".$query;
            return parent::run($query, $bindings, $callback);
        } finally {
            $span->end();
        }
    }
}
