<?php

namespace Mainto\RpcServer\Tracing\Support\Zipkin;

use GuzzleHttp\Client;
use Mainto\RpcServer\Tracing\Interfaces;
use Illuminate\Support\Facades\Log;
use Mainto\RpcServer\Tracing\Source;
use Throwable;

class Exporter implements Interfaces\Exporter {
    /**
     * @var string
     */
    private string $uri = 'http://127.0.0.1:9411/api/v2/spans';

    /**
     * @var Converter
     */
    private Converter $converter;

    /**
     * 实例化
     */
    public function __construct () {
        $this->converter = new Converter();
    }

    /**
     * @param array $spans
     * @param Source $source
     */
    public function export (array $spans, Source $source): void {
        // 默认值
        $convertSpans = $this->converter->converts($spans, $source);
        // 防止报错
        try {
            Log::debug('traceData', $convertSpans);
            // 提交
            (new Client())->post($this->uri, [
                'json' => $convertSpans,
            ]);
        } catch (Throwable $e) {
            Log::error('tracing upload fail: '.$e->getMessage());
        }
    }
}
