<?php

namespace Mainto\RpcServer\Tracing\Listeners;

use Illuminate\Database\Events\QueryExecuted;
use Mainto\RpcServer\Tracing\Context;
use Mainto\RpcServer\Tracing\Span;
use Mainto\RpcServer\Util\Types\Map;

class DatabaseQueryListener {
    /**
     * Handle the event.
     *
     * @param QueryExecuted $event
     * @return void
     */
    public function handle (QueryExecuted $event) {
        $span = Context::currentSpan();
        if (empty($span)) {
            $span = Span::start('mysql_executed');
        }

        $span->addEvent('mysql_executed', new Map([
            'connection_name' => $event->connectionName,
            'sql' => $event->sql,
            'time' => $event->time,
            'bindings' => join(',', $event->bindings)
        ]));
    }
}
