<?php

namespace Mainto\RpcServer\Tracing\Traits;

trait Timer {

    /**
     * @var int
     */
    private int $microsecond = 1000000; // 1e6

    /**
     * @var int
     */
    protected int $start = 0;

    /**
     * @var int
     */
    protected int $end = 0;

    /**
     * @var int
     */
    protected int $duration = 0;

    /**
     * @return int
     */
    public function getStart (): int {
        return $this->start;
    }

    /**
     * @return int
     */
    public function getEnd (): int {
        return $this->end;
    }

    /**
     * @return int
     */
    public function getDuration (): int {
        if ($this->isRecording()) {
            $this->end();
        }

        return $this->duration;
    }

    /**
     * @return bool
     */
    public function isRecording (): bool {
        return null === $this->end;
    }
}
