<?php

namespace Mainto\RpcServer\Tracing\Traits;

use Mainto\RpcServer\Tracing\Event;

trait Events {
    /**
     * @var array
     */
    protected array $events = [];

    /**
     * @param string $name
     * @param int $timestamp
     * @param array $attributes
     */
    public function addEvent (string $name, int $timestamp, array $attributes = []) {
        array_push($this->events, new Event($name, $timestamp, $attributes));
    }

    /**
     * @param Event $event
     */
    public function appendEvent (Event $event) {
        array_push($this->events, $event);
    }

    /**
     * @return array|Event[]
     */
    public function getEvents (): array {
        return $this->events;
    }
}
