<?php

namespace Mainto\RpcServer\Command;

use Illuminate\Console\Command;
use Mainto\RpcServer\Command\Sidecar\Sidecar;
use Mainto\RpcServer\RpcServer\Definition\Controller;
use Mainto\RpcServer\RpcServer\Definition\Method;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use Mainto\RpcServer\RpcServer\RpcRouter;

/**
 * Class RpcRegisterCommand
 * @package Mainto\RpcServer\Command
 */
class RpcDefinitionCommand extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:definition {option}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Register Info Command';

    public function handle () {
        switch ($this->argument('option')) {
            case 'controller':
                dump(RpcDefinition::getInstance()->controllers->mapWithKey(function (Controller $controller, $registerName) {
                    return [$registerName => $controller->namespace.'\\'.$controller->name];
                }));
                break;
            case 'url':
                $map = [];
                RpcDefinition::getInstance()->controllers->each(function (Controller $controller) use (&$map) {
                    $controller->methods->each(function (Method $method) use (&$map) {
                        if ($method->httpApi) {
                            $map[$method->httpApi->toString()] = $method->path();
                        }
                    });
                });
                dump($map);
                break;
            case 'cron':
                $map = [];
                RpcDefinition::getInstance()->controllers->each(function (Controller $controller) use (&$map) {
                    $controller->methods->each(function (Method $method) use (&$map) {
                        if ($method->cronHookName) {
                            $map[$method->cronSpec] = $method->path();
                        }
                    });
                });
                dump($map);
                break;
            case 'version':
                dump(RpcDefinition::getInstance()->allVersion());
                break;
            case 'router':
                $map = [];
                RpcDefinition::getInstance()->controllers->each(function (Controller $controller) use (&$map) {
                    $controller->methods->each(function (Method $method) use ($controller, &$map) {
                        $map[$controller->registerName][] = $method->path();
                    });
                });
                dump($map);
                break;
        }
    }
}