<?php

namespace Mainto\RpcServer\Tracing\Traits;

use Mainto\RpcServer\Util\Types\Map;

trait Resource {
    /**
     * @var Map<string, string>
     */
    protected Map $resource;

    /**
     * Map数组
     */
    public function __construct () {
        $this->resource = new Map();
    }

    /**
     * @param string $key
     * @param string $value
     * @return $this
     */
    public function setResource (string $key, string $value): self {
        $this->resource->set($key, $value);
        return $this;
    }

    /**
     * @return Map
     */
    public function getResources (): Map {
        return $this->resource;
    }
}
