<?php


namespace Mainto\RpcServer\RpcServer\ContextTrait;

use Mainto\RpcServer\Protocol\Common\Types\RequestHeaderType;

trait UrlTrait {
    use RequestTrait;

    /**
     * 是否是url请求
     *
     * @return bool
     */
    public function isRpcUrlRequest (): bool {
        return in_array($this->request->getType(), [
            RequestHeaderType::UrlInvokeGetType,
            RequestHeaderType::UrlInvokePostType,
            RequestHeaderType::UrlInvokePutType,
            RequestHeaderType::UrlInvokeDeleteType,
            RequestHeaderType::UrlInvokePatchType,
        ]);
    }
}