<?php

namespace Mainto\RpcServer\Tracing\Traits;

use Mainto\RpcServer\Tracing\Event;
use Mainto\RpcServer\Util\Types\Map;

trait Events {
    /**
     * @var array
     */
    protected array $events = [];

    /**
     * @param string $name
     * @param int $timestamp
     * @param Map|null $attributes
     */
    public function addEvent (string $name, ?Map $attributes = null, int $timestamp = 0) {
        $this->events[] = new Event($name, $timestamp, $attributes);
    }

    /**
     * @param Event $event
     */
    public function appendEvent (Event $event) {
        $this->events[] = $event;
    }

    /**
     * @return array|Event[]
     */
    public function getEvents (): array {
        return $this->events;
    }
}
