<?php

namespace Mainto\RpcServer\Tracing\Extend;

use Illuminate\Support\Facades\Facade;
use Mainto\RpcServer\RpcUtil\JsonHelper;
use Mainto\RpcServer\Tracing\Interfaces\SpanKind;
use Mainto\RpcServer\Tracing\Span;
use Throwable;

/**
 * 链路门面
 */
abstract class TraceFacade extends Facade {
    /**
     * @var int
     */
    protected static int $spanKind = SpanKind::KIND_INTERNAL;

    /**
     * @param string $method
     * @param array $args
     * @return string
     */
    protected static function getSpanName (string $method = '', array $args = []): string {
        return sprintf('TraceFacade %s::%s', static::getFacadeAccessor(), $method);
    }

    /**
     * @return string
     */
    protected static function getAttributeKey (): string {
        return 'args';
    }

    /**
     * @param string $method
     * @param array $args
     * @return mixed
     * @throws Throwable
     */
    public static function __callStatic ($method, $args) {
        $span = Span::start(static::getSpanName($method, $args), null, static::$spanKind);
        try {
            if (!empty($args)) {
                $span->setAttribute(static::getAttributeKey(), JsonHelper::encodeWithUnescapedAndError($args));
            }
            return parent::__callStatic($method, $args);
        } catch (Throwable $e) {
            $span->statusError($e->getMessage());
            throw $e;
        } finally {
            $span->end();
        }
    }
}