<?php

namespace Mainto\RpcServer\Providers;

use GuzzleHttp\Client;
use GuzzleHttp\HandlerStack;
use Illuminate\Foundation\Support\Providers\EventServiceProvider;
use Illuminate\Http\Client\Factory;
use Mainto\RpcServer\Tracing\Extend\GuzzleHttp\Middleware;
use Mainto\RpcServer\Tracing\Extend\Substitute\Cache;
use Mainto\RpcServer\Tracing\Extend\Substitute\HttpFactory;

/**
 * 链路相关Provider
 */
class TracingProvider extends EventServiceProvider {

    /**
     * @return void
     */
    public function register () {
        $this->substitute();
        $this->bind();
    }

    /**
     * 进行对象替换继承
     *
     * @return void
     */
    private function substitute (): void {
        // 替换Cache对象
        $this->app->extend('cache', function ($cache, $app) {
            return new Cache($app);
        });
        // 替换HttpFactory对象
        $this->app->extend(Factory::class, function ($factory, $app) {
            return new HttpFactory($factory->getDispatcher());
        });
    }

    /**
     * 进行对象绑定
     *
     * @return void
     */
    private function bind (): void {
        // 注册guzzle的链路
        $this->app->bind(Client::class, function ($app, array $config = []) {
            if (!isset($config['handler'])) {
                $config['handler'] = HandlerStack::create();
            }
            $config['handler']->push(Middleware::traceMiddleware(), 'trace');
            return new Client($config);
        });
    }
}
