<?php


namespace Mainto\RpcServer\Providers\SqlTrace;

use Closure;
use Mainto\RpcServer\RpcServer\RpcInvoke;
use Mainto\RpcServer\RpcUtil\JsonHelper;
use Mainto\RpcServer\Tracing\Interfaces\SpanKind;
use Mainto\RpcServer\Tracing\Span;

class MysqlConnection extends \Illuminate\Database\MySqlConnection {
    public function run ($query, $bindings, Closure $callback) {
        $span = Span::start('Mysql Connection::run', null, SpanKind::KIND_CLIENT);
        try {
            $span->setAttribute('db.sql', $query);
            // 判断是否为空，不为空则记录
            if (!empty($bindings)) {
                $span->setAttribute('db.bindings', JsonHelper::encodeWithUnescapedAndError($bindings));
            }
            // 兼容旧版pre环境要求
            if (in_array(config('rpc-server.environment'), config('rpc-server.sql_trace.environments'))) {
                $query = "/* TraceId: ".RpcInvoke::getCurrentTraceId()." */".$query;
            }
            return parent::run($query, $bindings, $callback);
        } finally {
            $span->end();
        }
    }
}
