<?php

namespace Mainto\RpcServer\Providers;

use Illuminate\Support\Str;
use Mainto\RpcServer\Base\Controller;
use Mainto\RpcServer\RpcServer\RpcRouter;

class AutoScanProvider extends \Illuminate\Support\ServiceProvider {
    public function register() {
        $appDir = app_path();
        if (RpcRouter::getAppDir()) {
            $appDir = RpcRouter::getAppDir();
        }

        foreach (get_classes($appDir) as $class) {
            if (Str::endsWith($class, 'Controller') && is_subclass_of($class, Controller::class)) {
                $classImplements = class_implements($class);
                foreach ($classImplements as $implement) {
                    $this->app->singleton($implement, $class);
                }
            }
        }
    }
}