<?php

namespace Mainto\RpcServer\Tracing\Interfaces;

interface SourceKey {
    /**
     * TelemetrySDK
     */
    const TelemetrySDKNameKey = 'telemetry.sdk.name';
    const TelemetrySDKLanguageKey = 'telemetry.sdk.language';
    const TelemetrySDKVersionKey = 'telemetry.sdk.version';

    /**
     * Host
     */
    const HostNameKey = 'host.name';

    /**
     * OS
     */
    const OSTypeKey = 'os.type';
    const OSDescriptionKey = 'os.description';
    const OSNameKey = 'os.name';
    const OSVersionKey = 'os.version';

    /**
     * K8s
     */
    const K8SClusterNameKey = 'k8s.cluster.name';
    const K8SNodeNameKey = 'k8s.node.name';
    const K8SNodeUIDKey = 'k8s.node.uid';
    const K8SNamespaceNameKey = 'k8s.namespace.name';
    const K8SPodUIDKey = 'k8s.pod.uid';
    const K8SPodNameKey = 'k8s.pod.name';
    const K8SContainerNameKey = 'k8s.container.name';
    const K8SReplicasetUIDKey = 'k8s.replicaset.uid';
    const K8SReplicasetNameKey = 'k8s.replicaset.name';

    /**
     * process
     */
    const ProcessPIDKey = 'process.pid';

    /**
     * service
     */
    const ServiceNameKey = 'service.name';
    const ServiceVersionKey = 'service.version';
}