<?php

namespace Mainto\RpcServer\Tracing\Listeners;

use Illuminate\Database\Events\QueryExecuted;
use Mainto\RpcServer\Tracing\Context;
use Mainto\RpcServer\Tracing\Span;
use Mainto\RpcServer\Util\Types\Map;

class DatabaseQueryListener {
    /**
     * @var string
     */
    protected string $name = 'MysqlExecuted';

    /**
     * Handle the event.
     *
     * @param QueryExecuted $event
     * @return void
     */
    public function handle (QueryExecuted $event) {
        $span = Context::currentSpan();
        if (empty($span)) {
            $span = Span::start($this->name);
        }

        $span->addEvent($this->name, new Map([
            'connection_name' => $event->connectionName,
            'time'            => $event->time,
        ]));
    }
}
