<?php


namespace Mainto\RpcServer\Providers\SqlTrace;

use Closure;
use Mainto\RpcServer\RpcServer\RpcInvoke;
use Mainto\RpcServer\Tracing\Interfaces\SpanKind;
use Mainto\RpcServer\Tracing\Span;

class MysqlConnection extends \Illuminate\Database\MySqlConnection {
    public function run ($query, $bindings, Closure $callback) {
        $span = Span::start('Mysql Executed', null, SpanKind::KIND_CLIENT);
        try {
            $span->setAttribute('db.sql', $query);
            $span->setAttribute('db.bindings', json_encode($bindings));
            if (in_array(config('rpc-server.environment'), config('rpc-server.sql_trace.environments'))) {
                $query = "/* TraceId: ".RpcInvoke::getCurrentTraceId()." */".$query;
            }
            return parent::run($query, $bindings, $callback);
        } finally {
            $span->end();
        }
    }
}
