<?php

namespace Mainto\RpcServer\Tracing\Listeners;

use Illuminate\Cache\Events\CacheMissed;
use Mainto\RpcServer\Tracing\Context;
use Mainto\RpcServer\Tracing\Span;
use Mainto\RpcServer\Util\Types\Map;

class CacheMissedListener {
    /**
     * @var string
     */
    protected string $name = 'CacheMissed';

    /**
     * Handle the event.
     *
     * @param CacheMissed $event
     * @return void
     */
    public function handle (CacheMissed $event) {
        $span = Context::currentSpan();
        if (empty($span)) {
            $span = Span::start($this->name);
        }
        $span->addEvent($this->name, new Map([
            'key' => $event->key,
        ]));
    }
}