<?php

namespace Mainto\RpcServer\Tracing\Traits;

use Mainto\RpcServer\Util\Types\Map;

trait Attributes {
    /**
     * @var Map
     */
    protected Map $attributes;

    /**
     * @param string $key
     * @param string $value
     *
     * @return Attributes
     */
    public function setAttribute (string $key, string $value): self {
        $this->attributes->set($key, $value);
        return $this;
    }

    /**
     * @return Map
     */
    public function getAttributes (): Map {
        return $this->attributes;
    }
}
