<?php

namespace Mainto\RpcServer\Tracing;

final class SdkVersion {
    /**
     * @var string
     */
    protected string $name = 'rpc-tracing';

    /**
     * @var string
     */
    protected string $version = '0.0.1';

    /**
     * @param string $name
     * @param string $version
     */
    public function __construct (string $name, string $version) {
        $this->name = $name;
        $this->version = $version;
    }

    /**
     * @return string
     */
    public function getName (): string {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getVersion (): string {
        return $this->version;
    }
}
