<?php

namespace Mainto\RpcServer\Tracing\Listeners;

use Illuminate\Redis\Events\CommandExecuted;
use Mainto\RpcServer\Tracing\Context;
use Mainto\RpcServer\Tracing\Span;
use Mainto\RpcServer\Util\Types\Map;

class RedisCommandExecuted {
    /**
     * Handle the event.
     *
     * @param CommandExecuted $event
     * @return void
     */
    public function handle (CommandExecuted $event) {
        $span = Context::currentSpan();
        if (empty($span)) {
            $span = Span::start('KeyWritten');
        }
        $span->addEvent('redis_command_executed', new Map([
            'connection_name' => $event->connectionName,
            'command'         => $event->command,
            'time'            => $event->time,
            'parameters'      => join(',', $event->parameters),
        ]));
    }
}
