<?php

namespace Mainto\RpcServer\Tracing\Listeners;

use Illuminate\Cache\Events\KeyWritten;
use Mainto\RpcServer\Tracing\Context;
use Mainto\RpcServer\Tracing\Span;
use Mainto\RpcServer\Util\Types\Map;

class KeyWrittenListener {
    /**
     * @var string
     */
    protected string $name = 'CacheKeyWritten';

    /**
     * Handle the event.
     *
     * @param KeyWritten $event
     * @return void
     */
    public function handle (KeyWritten $event) {
        $span = Context::currentSpan();
        if (empty($span)) {
            $span = Span::start($this->name);
        }
        $span->addEvent($this->name, new Map([
            'key'     => $event->key,
            'value'   => $event->value,
            'seconds' => $event->seconds,
        ]));
    }
}