<?php

namespace Mainto\RpcServer\Tracing;

use Mainto\RpcServer\Tracing\Interfaces\Time;
use Mainto\RpcServer\Tracing\Traits\Attributes;
use Mainto\RpcServer\Util\Types\Map;

class Event {
    use Attributes;

    /**
     * @var string
     */
    private string $name;

    /**
     * @var float
     */
    private float $timestamp;

    /**
     * @param string $name
     * @param float $timestamp
     * @param Map|null $attributes
     */
    public function __construct (string $name, float $timestamp = 0, ?Map $attributes = null) {
        $this->name = $name;
        $this->timestamp = ($timestamp ?: \microtime(true)) * Time::MICRO_SECOND;
        $this->attributes = $attributes ?: new Map();
    }

    /**
     * @return string
     */
    public function getName (): string {
        return $this->name;
    }

    /**
     * @return float
     */
    public function getTimestamp (): float {
        return $this->timestamp;
    }
}
