<?php


namespace Mainto\RpcServer\Protocol\Request\Extend;


use Mainto\RpcServer\Protocol\Common\MapReadWrite;
use Mainto\RpcServer\Protocol\Request\Extend;
use Mainto\RpcServer\Protocol\Request\HeaderExtend;
use Mainto\RpcServer\Util\IO\Reader;
use Mainto\RpcServer\Util\IO\Writer;

class RequestExtendHeader implements HeaderExtend {
    protected array $header = [];

    protected function checkAndAdd (array &$map, string $key, string $value) {
        if (strlen($key) < 255 && strlen($value) < 65535) {
            if (!isset($map[$key])) {
                $map[$key] = [];
            }

            $map[$key][] = $value;
        }
    }

    protected function checkAndSet (array &$map, string $key, array $values) {
        if (strlen($key) > 255) {
            return;
        }

        foreach ($values as $value) {
            if (strlen($value) >= 65535) {
                return;
            }
        }

        $map[$key] = $values;
    }

    public function addHeader (string $key, string $value) {
        $this->checkAndAdd($this->header, $key, $value);
    }

    public function setHeader (string $key, array $values) {
        $this->checkAndSet($this->header, $key, $values);
    }

    /**
     * @return array
     */
    public function getAllHeader (): array {
        return $this->header;
    }

    /**
     * @param string $key
     * @return array
     */
    public function getHeader (string $key): array {
        return $this->header[$key] ?? [];
    }

    public function writeHeaderTo (Writer $writer): int {
        return MapReadWrite::littleWriteMapTo($this->header, $writer);
    }

    public function readHeaderFrom (Reader $reader): int {
        return MapReadWrite::littleReadMapFrom($this->header, $reader);
    }

    public function magicNum () {
        return Extend::MagicNumHeaderExtend;
    }

    public function checkParams () {
    }

    public function toArray (): array {
        return [
            'type'   => 'RequestExtendHeader',
            'header' => $this->header,
        ];
    }

    public function dumpToWriter (Writer $writer) {
        return json_encode($this->toArray(), JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    }
}