<?php


namespace Mainto\RpcServer\Protocol\Common\Types;


use Mainto\RpcServer\Protocol\Common\BaseType;

class RequestHeaderType {

    const UrlInvokeType = 1;
    const InternalInvokeType = 2;
    const MessageType = 3;
    const CronType = 4;
    const WebsocketType = 5;
    const CheckType = 7;
    const SidecarType = 8;

    /**
     *  - url invoke - 1
     *    + get - 1
     *    + post - 2
     *    + put - 3
     *    + delete - 4
     *    + patch - 5
     */
    const UrlInvokeGetType = ((self::UrlInvokeType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (1 & BaseType::SecondTypeMask);
    const UrlInvokePostType = ((self::UrlInvokeType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (2 & BaseType::SecondTypeMask);
    const UrlInvokePutType = ((self::UrlInvokeType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (3 & BaseType::SecondTypeMask);
    const UrlInvokeDeleteType = ((self::UrlInvokeType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (4 & BaseType::SecondTypeMask);
    const UrlInvokePatchType = ((self::UrlInvokeType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (5 & BaseType::SecondTypeMask);

    /**
     *  - invoke - 2
     *      + normal - 1
     */
    const InvokeNormalType = ((self::InternalInvokeType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (1 & BaseType::SecondTypeMask);

    /**
     *  - message - 3
     *    + normal - 1
     *    + delay - 2
     *    + retry - 3
     *    + queue - 4
     */
    const MessageNormalType = ((self::MessageType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (1 & BaseType::SecondTypeMask);
    const MessageDelayType = ((self::MessageType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (2 & BaseType::SecondTypeMask);
    const MessageRetryType = ((self::MessageType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (3 & BaseType::SecondTypeMask);
    const MessageQueueType = ((self::MessageType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (4 & BaseType::SecondTypeMask);

    /**
     *  - cron - 4
     *    + normal - 1
     */
    const CronNormalType = ((self::CronType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (1 & BaseType::SecondTypeMask);

    /**
     *  - websocket - 5
     *    + normal -1
     *    + connect -2
     *    + disconnect -3
     */
    const WebsocketNormalType = ((self::WebsocketType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (1 & BaseType::SecondTypeMask);
    const WebsocketConnectType = ((self::WebsocketType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (2 & BaseType::SecondTypeMask);
    const WebsocketDisconnectType = ((self::WebsocketType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (3 & BaseType::SecondTypeMask);

    /**
     *  - check - 7
     *    + system check 1
     */
    const SystemCheckType = ((self::CheckType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (1 & BaseType::SecondTypeMask);

    /**
     *  - sidecar control - 8
     *    + scale 1
     *    + config 2
     *    + stop 3
     *    + setting 4
     *    + sls 5
     *    + monitor 6
     */
    const SidecarScaleUpType = ((self::SidecarType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (1 & BaseType::SecondTypeMask);
    const SidecarConfigType = ((self::SidecarType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (2 & BaseType::SecondTypeMask);
    const SidecarStopType = ((self::SidecarType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (3 & BaseType::SecondTypeMask);
    const SidecarSettingType = ((self::SidecarType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (4 & BaseType::SecondTypeMask);
    const SidecarSLSType = ((self::SidecarType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (5 & BaseType::SecondTypeMask);
    const SidecarMonitorType = ((self::SidecarType << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (6 & BaseType::SecondTypeMask);
}