<?php

namespace Mainto\RpcServer\Tracing\Extend\Substitute;

use Illuminate\Cache\CacheManager;
use Mainto\RpcServer\RpcUtil\JsonHelper;
use Mainto\RpcServer\Tracing\Interfaces\SpanKind;
use Mainto\RpcServer\Tracing\Span;

/**
 * 替换Cache门面实例CacheManager对象使用
 */
class Cache extends CacheManager {
    /**
     * @param string $method
     * @param array $parameters
     * @return mixed
     */
    public function __call ($method, $parameters) {
        // 链路span名称
        $spanName = sprintf('Cache %s::%s', strtoupper($this->getDefaultDriver()), $method);
        // 开启链路
        $span = Span::start($spanName, null, SpanKind::KIND_CLIENT);
        // 判断是否存在参数
        if (!empty($parameters)) {
            // 增加属性
            $span->setAttribute('cache.params', JsonHelper::encodeWithUnescapedAndError($parameters));
        }
        // 进行finally处理
        try {
            // 调用父类
            return parent::__call($method, $parameters);
        } finally {
            // 结束链路
            $span->end();
        }
    }
}