<?php

namespace Mainto\RpcServer\Tracing\Extend;

use GuzzleHttp\Client;
use GuzzleHttp\HandlerStack;
use Illuminate\Http\Client\Factory;
use Mainto\RpcServer\Tracing\Extend\GuzzleHttp\Middleware;
use Mainto\RpcServer\Tracing\Extend\Substitute\Cache;
use Mainto\RpcServer\Tracing\Extend\Substitute\HttpFactory;

/**
 * 链路注册对象
 */
class Register {
    /**
     * @return void
     */
    public function handle (): void {
        // 注册替换
        $this->substitute();
        // 进行app bind 对象绑定
        $this->bind();
    }

    /**
     * 进行对象替换继承
     *
     * @return void
     */
    private function substitute (): void {
        // 替换Cache对象
        app()->extend('cache', function ($cache, $app) {
            return new Cache($app);
        });
        // 替换HttpFactory对象
        app()->extend(Factory::class, function ($factory, $app) {
            return new HttpFactory($factory->getDispatcher());
        });
    }

    /**
     * 进行对象绑定
     *
     * @return void
     */
    private function bind (): void {
        // 注册guzzle的链路
        app()->bind(Client::class, function ($app, array $config = []) {
            if (!isset($config['handler'])) {
                $config['handler'] = HandlerStack::create();
            }
            $config['handler']->push(Middleware::traceMiddleware(), 'trace');
            return new Client($config);
        });
    }
}