<?php


namespace Mainto\RpcServer\Util\Net;


use Mainto\RpcServer\Util\Net\Listener\TcpListener;
use Mainto\RpcServer\Util\Net\Listener\UnixListener;
use RuntimeException;

class Net {
    public static function dial ($network, $address): Conn {
        switch ($network) {
            case "unix":
                return Dialer::dialUnix($address);
            case "tcp":
                return Dialer::dialTcp($address);
            case "fastmq":
                return Dialer::dialFastMQ($address);
        }

        throw new RuntimeException("not support network");
    }

    public static function listen($network, $address): Listener {
        switch ($network) {
            case "unix":
                return new UnixListener($address);
            case "tcp":
                return new TcpListener($address);
        }

        throw new RuntimeException("not support network");
    }
}