<?php


namespace Mainto\RpcServer\Command;


use Illuminate\Console\Command;
use Mainto\RpcServer\Log\LogHandler;
use Mainto\RpcServer\RpcServer\Connection\RpcFastMqConnection;
use Mainto\RpcServer\RpcServer\ConnectionHandler\ChildConnectionHandler;

class RpcChildFastMqCommand extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:child-fastmq {--name=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Worker Command';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct () {
        parent::__construct();
    }

    public function handle () {
        $name = $this->option('name');

        LogHandler::init(storage_path("logs/service/".now()->format("Y-m-d")), 'child');

        RpcFastMqConnection::mustNewInstance($name, new ChildConnectionHandler(), 3)->start();
    }
}