<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/7/31
 * Time: 上午10:13
 */

namespace Mainto\RpcServer\RpcAnnotations;


use Doctrine\Common\Annotations\Annotation\Attribute;
use Doctrine\Common\Annotations\Annotation\Attributes;

/**
 * Class RpcMessageQueueHook
 * @package Mainto\RpcServer\RpcAnnotations
 *
 * @Annotation
 * @Target({"METHOD"})
 *
 * @Attributes({
 *     @Attribute("topicName", type = "string"),
 *     @Attribute("concurrencyNum", type = "int"),
 * })
 */
class RpcMessageQueueHook {
    /**
     * hook name
     *
     * @Required
     * @var string
     */
    public string $topicName;

    /**
     * 并发消费数 (当为1时，该topic下最大并行1个线程顺序消费消息; 当为3时, 最大并行3个线程顺序消费消息)
     *
     * 1. 即 当为 1 时，单线程完全顺序消费
     * message1 -> message2 -> message3
     *
     * 2. 当为3时，一次对服务发起最多3次调用，1~3条消息不保证有序; 但是 1~3 的消息一定比 4~6更早消费
     * message1 -> message4 -> message7
     * message2    message5    message8
     * message3    message6    message9
     *
     * @var int
     */
    public int $concurrencyNum = 1;
}