<?php


namespace Mainto\RpcServer\RpcClient;


use WeakReference;

trait RpcClientWeakRef {
    /**
     * @return RpcClient
     */
    protected function getClient(): RpcClient {
        $client = $this->clientWeakRef->get();
        if ($client == null) {
            $client = RpcClientFactory::getClient($this->createClientOption[0], array_slice($this->createClientOption, 1));
            $this->clientWeakRef = WeakReference::create($client);
        }

        return $client;
    }

    /**
     * [method, args]
     * @var array
     */
    protected array $createClientOption = [];

    /**
     * Rpc 客户端
     * @var WeakReference
     */
    protected WeakReference $clientWeakRef;

    public function weakRefInit() {
        $this->clientWeakRef = WeakReference::create(RpcClientFactory::getClient($this->createClientOption[0], array_slice($this->createClientOption, 1)));
    }

    public function clearClient() {
        $client = $this->clientWeakRef->get();
        if ($client) {
            RpcClientFactory::clearClient($client);
        }
    }
}