<?php


namespace Mainto\RpcServer\Providers;


use Illuminate\Support\ServiceProvider;
use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcServer\RpcSessionHandlerInterface;
use Mainto\RpcServer\RpcUtil\SessionHandler\SessionTestHandler;

/**
 * Class SessionDefaultProvider
 * @package Mainto\RpcServer\Providers
 */
class SessionProvider extends ServiceProvider {
    public function register () {
        if (config('rpc-server.session_driver') == 'gear-store') {
            $this->app->singleton(RpcSessionHandlerInterface::class, function () {
                return new class implements RpcSessionHandlerInterface {
                    private function getStore () {
                        return RpcClass::getClass("CoreGear", "Store");
                    }

                    public function getSessionStringBySessionId ($sessionId): ?string {
                        return $this->getStore()->get([
                            "key" => $sessionId,
                        ]);
                    }

                    public function updateSession ($sessionId, $sessionString, $seconds): void {
                        $this->getStore()->set([
                            "key"        => $sessionId,
                            "value"      => $sessionString,
                            "expireTime" => $seconds,
                        ]);
                    }

                    public function deleteSession ($sessionId): void {
                        $this->getStore()->delete([
                            "key" => $sessionId,
                        ]);
                    }
                };
            });
        } else {
            $this->app->singleton(RpcSessionHandlerInterface::class, SessionTestHandler::class);
        }
    }
}