<?php

namespace Mainto\RpcServer\Providers;

use Mainto\RpcServer\Base\Controller;
use Mainto\RpcServer\RpcServer\RpcRouter;

class AutoScanProvider extends \Illuminate\Support\ServiceProvider {
    public function register() {
        $appDir = app_path();
        if (RpcRouter::getAppDir()) {
            $appDir = RpcRouter::getAppDir();
        }

        foreach (get_classes($appDir) as $class) {
            if (is_subclass_of($class, Controller::class)) {
                $classImplements = class_implements($class);
                foreach ($classImplements as $implement) {
                    $this->app->singleton($implement, $class);
                }
            }
        }
    }
}